<?php
include 'index.php';
?>
<section class="pc-container">
    <div class="pc-content">
        <div class="row">
            <div class="mb-4 d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Supplier</h2>
                <button class="btn btn-success rounded" data-bs-toggle="modal" data-bs-target="#addSupplierModal">
                    <i class="ti ti-plus"></i> Tambah Supplier
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <h5>Daftar Supplier</h5>
                        <small>Kelola data supplier obat</small>
                    </div>
                    <div class="card-body">
                        <div class="dt-responsive">
                            <table id="dom-jqry" class="table table-striped table-bordered nowrap">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Supplier</th>
                                        <th>Alamat</th>
                                        <th>Telepon</th>
                                        <th>Email</th>
                                        <th class="text-center">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $query = "SELECT * FROM supplier ORDER BY id_supplier DESC";
                                    $result = mysqli_query($conn, $query);
                                    $no = 1;
                                    while ($row = mysqli_fetch_assoc($result)) {
                                    ?>
                                    <tr>
                                        <td><?= $no++ ?></td>
                                        <td><?= $row['nama_supplier'] ?></td>
                                        <td><?= $row['alamat'] ?></td>
                                        <td><?= $row['telepon'] ?></td>
                                        <td><?= $row['email'] ?></td>
                                        <td class="text-center">
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editSupplierModal<?php echo $row['id_supplier']; ?>" title="Edit">
                                                <i class="ti ti-edit"></i>
                                            </button>
                                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#deleteSupplierModal<?php echo $row['id_supplier']; ?>" title="Hapus">
                                                <i class="ti ti-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modal Tambah Supplier -->
<div class="modal fade" id="addSupplierModal" tabindex="-1" aria-labelledby="addSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addSupplierModalLabel">Tambah Supplier</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addSupplierForm" action="tambahsupplier.php" method="POST">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="nama_supplier" class="form-label">Nama Supplier</label>
                                <input type="text" class="form-control" id="nama_supplier" name="nama_supplier" placeholder="Contoh: PT. Kimia Farma" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="telepon" class="form-label">Telepon</label>
                                <input type="text" class="form-control" id="telepon" name="telepon" placeholder="Contoh: 021-12345678" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="email" class="form-label">Email</label>
                                <input type="email" class="form-control" id="email" name="email" placeholder="Contoh: supplier@email.com" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="alamat" class="form-label">Alamat</label>
                                <textarea class="form-control" id="alamat" name="alamat" rows="3" placeholder="Alamat lengkap supplier" required></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-success" name="tambah">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php
    $query = "SELECT * FROM supplier ORDER BY id_supplier DESC";
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
?>
<!-- Modal Edit Supplier -->
<div class="modal fade" id="editSupplierModal<?php echo $row['id_supplier']; ?>" tabindex="-1" aria-labelledby="editSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editSupplierModalLabel">Edit Supplier</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="editSupplierForm" action="editsupplier.php" method="POST">
                <input type="hidden" name="id_supplier" value="<?php echo $row['id_supplier']; ?>">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_nama_supplier<?php echo $row['id_supplier']; ?>" class="form-label">Nama Supplier</label>
                                <input type="text" class="form-control" id="edit_nama_supplier<?php echo $row['id_supplier']; ?>" name="nama_supplier" value="<?php echo $row['nama_supplier']; ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_telepon<?php echo $row['id_supplier']; ?>" class="form-label">Telepon</label>
                                <input type="text" class="form-control" id="edit_telepon<?php echo $row['id_supplier']; ?>" name="telepon" value="<?php echo $row['telepon']; ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="edit_email<?php echo $row['id_supplier']; ?>" class="form-label">Email</label>
                                <input type="email" class="form-control" id="edit_email<?php echo $row['id_supplier']; ?>" name="email" value="<?php echo $row['email']; ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="mb-3">
                                <label for="edit_alamat<?php echo $row['id_supplier']; ?>" class="form-label">Alamat</label>
                                <textarea class="form-control" id="edit_alamat<?php echo $row['id_supplier']; ?>" name="alamat" rows="3" required><?php echo $row['alamat']; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Tutup</button>
                    <button type="submit" class="btn btn-warning" name="edit">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Hapus Supplier -->
<div class="modal fade" id="deleteSupplierModal<?php echo $row['id_supplier']; ?>" tabindex="-1" aria-labelledby="deleteSupplierModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteSupplierModalLabel">Konfirmasi Hapus</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="deleteSupplierForm" action="hapussupplier.php" method="POST">
                <input type="hidden" name="id_supplier" value="<?php echo $row['id_supplier']; ?>">
                <div class="modal-body">
                    <p>Apakah Anda yakin ingin menghapus supplier <strong><?php echo $row['nama_supplier']; ?></strong>?</p>
                    <div class="alert alert-warning">
                        <i class="ti ti-alert-triangle"></i> Data yang dihapus tidak dapat dikembalikan!
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger" name="hapus">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php } ?>

<?php include 'footer.php'; ?>